<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\NetworkServices;

class HttpRouteRouteMatch extends \Google\Collection
{
  protected $collection_key = 'queryParameters';
  /**
   * @var string
   */
  public $fullPathMatch;
  /**
   * @var HttpRouteHeaderMatch[]
   */
  public $headers;
  protected $headersType = HttpRouteHeaderMatch::class;
  protected $headersDataType = 'array';
  /**
   * @var bool
   */
  public $ignoreCase;
  /**
   * @var string
   */
  public $prefixMatch;
  /**
   * @var HttpRouteQueryParameterMatch[]
   */
  public $queryParameters;
  protected $queryParametersType = HttpRouteQueryParameterMatch::class;
  protected $queryParametersDataType = 'array';
  /**
   * @var string
   */
  public $regexMatch;

  /**
   * @param string
   */
  public function setFullPathMatch($fullPathMatch)
  {
    $this->fullPathMatch = $fullPathMatch;
  }
  /**
   * @return string
   */
  public function getFullPathMatch()
  {
    return $this->fullPathMatch;
  }
  /**
   * @param HttpRouteHeaderMatch[]
   */
  public function setHeaders($headers)
  {
    $this->headers = $headers;
  }
  /**
   * @return HttpRouteHeaderMatch[]
   */
  public function getHeaders()
  {
    return $this->headers;
  }
  /**
   * @param bool
   */
  public function setIgnoreCase($ignoreCase)
  {
    $this->ignoreCase = $ignoreCase;
  }
  /**
   * @return bool
   */
  public function getIgnoreCase()
  {
    return $this->ignoreCase;
  }
  /**
   * @param string
   */
  public function setPrefixMatch($prefixMatch)
  {
    $this->prefixMatch = $prefixMatch;
  }
  /**
   * @return string
   */
  public function getPrefixMatch()
  {
    return $this->prefixMatch;
  }
  /**
   * @param HttpRouteQueryParameterMatch[]
   */
  public function setQueryParameters($queryParameters)
  {
    $this->queryParameters = $queryParameters;
  }
  /**
   * @return HttpRouteQueryParameterMatch[]
   */
  public function getQueryParameters()
  {
    return $this->queryParameters;
  }
  /**
   * @param string
   */
  public function setRegexMatch($regexMatch)
  {
    $this->regexMatch = $regexMatch;
  }
  /**
   * @return string
   */
  public function getRegexMatch()
  {
    return $this->regexMatch;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(HttpRouteRouteMatch::class, 'Google_Service_NetworkServices_HttpRouteRouteMatch');
