<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dataproc;

class AuxiliaryServicesConfig extends \Google\Model
{
  /**
   * @var MetastoreConfig
   */
  public $metastoreConfig;
  protected $metastoreConfigType = MetastoreConfig::class;
  protected $metastoreConfigDataType = '';
  /**
   * @var SparkHistoryServerConfig
   */
  public $sparkHistoryServerConfig;
  protected $sparkHistoryServerConfigType = SparkHistoryServerConfig::class;
  protected $sparkHistoryServerConfigDataType = '';

  /**
   * @param MetastoreConfig
   */
  public function setMetastoreConfig(MetastoreConfig $metastoreConfig)
  {
    $this->metastoreConfig = $metastoreConfig;
  }
  /**
   * @return MetastoreConfig
   */
  public function getMetastoreConfig()
  {
    return $this->metastoreConfig;
  }
  /**
   * @param SparkHistoryServerConfig
   */
  public function setSparkHistoryServerConfig(SparkHistoryServerConfig $sparkHistoryServerConfig)
  {
    $this->sparkHistoryServerConfig = $sparkHistoryServerConfig;
  }
  /**
   * @return SparkHistoryServerConfig
   */
  public function getSparkHistoryServerConfig()
  {
    return $this->sparkHistoryServerConfig;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AuxiliaryServicesConfig::class, 'Google_Service_Dataproc_AuxiliaryServicesConfig');
