<div id="primary-navigation">
  <div class="top-nav">
    <div class="container">
      <div class="top-nav-inner">
        <div class="top-nav-left">
          
          <?php if(is_incevio_package_loaded('zipcode') && Session::has('zipcode_default')): ?>
            <a class="modalAction" href="<?php echo e(route(config('zipcode.routes.shipTo')), false); ?>">
              <i class="fal fa-location-arrow"></i> <?php echo e(trans('theme.ship_to') . ' ' . Session::get('zipcode_default'), false); ?>

            </a>
          <?php else: ?>
            <h3><?php echo e(trans('theme.welcome') . ' ' . config('app.name'), false); ?></h3>
          <?php endif; ?>

          
        </div> <!-- /.top-nav-left -->

        <div class="top-nav-right">
          <ul>
            <?php if(auth()->guard('customer')->check()): ?>
              <li class="image-icon">
                <a href="<?php echo e(route('account', 'dashboard'), false); ?>">
                  <i class="fal fa-user"></i>
                  <span><?php echo e(trans('theme.hello') . ', ' . Auth::guard('customer')->user()->getName(), false); ?></span>
                </a>
              </li>

              <?php if(customer_can_register()): ?>
                <li class="image-icon">
                  <a href="<?php echo e(route('customer.logout'), false); ?>">
                    <i class="fal fa-power-off"></i>
                    <span><?php echo e(trans('theme.logout'), false); ?></span>
                  </a>
                </li>
              <?php else: ?>
                <li class="image-icon">
                  <a href="<?php echo e(route('customer.switchToMerchant'), false); ?>">
                    <i class="fal fa-dashboard"></i> <?php echo e(trans('theme.view_merchant_dashboard'), false); ?>

                  </a>
                </li>
              <?php endif; ?>
            <?php else: ?>
              <?php if(customer_can_register()): ?>
                <li class="image-icon">
                  <a href="javascript:void(0);" data-toggle="modal" data-target="#loginModal">
                    <i class="fal fa-user"></i>
                    <span><?php echo e(trans('theme.sing_in'), false); ?></span>
                  </a>
                </li>
              <?php else: ?>
                <li class="image-icon">
                  <a href="/login">
                    <i class="fal fa-user"></i>
                    <span><?php echo e(trans('theme.sing_in'), false); ?></span>
                  </a>
                </li>
              <?php endif; ?>
            <?php endif; ?>

            <?php if(is_wallet_configured_for('customer')): ?>
              <li class="image-icon">
                <a href="<?php echo e(route('customer.account.wallet'), false); ?>">
                  <i class="fas fa-wallet no-fill"></i>
                  <?php if(Auth::guard('customer')->check()): ?>
                    <strong><?php echo e(get_formated_currency(Auth::guard('customer')->user()->balance), false); ?></strong>
                  <?php else: ?>
                    <?php echo e(trans('packages.wallet.wallet'), false); ?>

                  <?php endif; ?>
                </a>
              </li>
            <?php endif; ?>

            

            <li class="image-icon">
              <a href="<?php echo e(route('account', 'orders'), false); ?>">
                <!-- <img src="images/truck.svg" alt=""> -->
                <i class="fal fa-map-marker-alt"></i> <?php echo e(trans('theme.track_your_order'), false); ?>

              </a>
            </li>

            <li class="image-icon">
              <a href="<?php echo e(get_page_url(\App\Models\Page::PAGE_CONTACT_US), false); ?>">
                <i class="fal fa-life-ring"></i> <?php echo e(trans('theme.support'), false); ?>

              </a>
            </li>

            <?php if(is_incevio_package_loaded('dynamic-currency')): ?>
              <li class="currency">
                <select name="currency" id="currencyChange">
                  <?php $__currentLoopData = get_active_currencies(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                      if (get_dynamic_currency_attr('iso_code') == $item->iso_code) {
                          $selected = 'selected';
                      } elseif (!session()->has('currency') && $item->iso_code == get_system_currency()) {
                          $selected = 'selected';
                      } else {
                          $selected = '';
                      }
                    ?>
                    <option value="<?php echo e($item->iso_code, false); ?>" <?php echo e($selected ?? '', false); ?>>
                      <?php echo e($item->iso_code ?? '', false); ?> (<?php echo e($item->symbol ?? '', false); ?>)
                    </option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </li>
            <?php endif; ?>

            <li class="language">
              <select id="languageChange" name="lang" class="dd-dropdown">
                <?php $__currentLoopData = config('active_locales'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option dd-link="<?php echo e(route('locale.change', $lang->code), false); ?>" value="<?php echo e($lang->code, false); ?>" data-imagesrc="<?php echo e(get_flag_img_by_code(array_slice(explode('_', $lang->php_locale_code), -1)[0], true), false); ?>" <?php echo e($lang->code == \App::getLocale() ? 'selected' : '', false); ?>>
                    <?php echo e($lang->language, false); ?>

                  </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </li> <!-- /.language -->
          </ul>
        </div> <!-- /.top-nav-right -->
      </div> <!-- /.top-nav-inner -->
    </div> <!-- /.container -->
  </div> <!-- /.top-nav -->

  <div id="header-main">
    <div class="container">
      <div class="row align-items-center align-items-lg-start justify-content-lg-between">
        <div class="col-7 col-lg-2 d-flex align-items-center justify-content-sm-between">
          <div class="header-menu-toggler">
            <div class="menu-icon">
              <a class="main-menu-toggle" href="javascript:void(0);"><i class="fal fa-bars"></i></a>
            </div>
          </div> <!-- /.header-menu-toggler -->

          <div class="header-logo">
            <a href="<?php echo e(url('/'), false); ?>">
              <img src="<?php echo e(get_logo_url('system', 'logo'), false); ?>" class="brand-logo" alt="<?php echo e(trans('theme.logo'), false); ?>" title="<?php echo e(trans('theme.logo'), false); ?>">
            </a>
          </div> <!-- /.header-logo -->
        </div> <!-- /.col-* -->

        <div class="col-lg-8 global-search">
          <div class="header-search d-flex ml-md-4 align-items-center">
            <span class="exit-search flex-center fal fa-times"></span>
            <?php echo Form::open(['route' => 'inCategoriesSearch', 'method' => 'GET', 'id' => 'search-categories-form', 'class' => 'navbar-left navbar-search w-100', 'role' => 'search']); ?>

            <div class="search-box">
              <div class="search-box-select d-none d-sm-block">
                <select class="category search-category-select" name="insubgrp" id="niceSelect">
                  <option value="all"><?php echo e(trans('theme.all_categories'), false); ?></option>

                  <?php $__currentLoopData = $search_category_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $search_category_grp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <optgroup label="<?php echo e($search_category_grp->name, false); ?>">
                      <?php $__currentLoopData = $search_category_grp->subGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $search_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($search_category->slug, false); ?>" <?php echo e(Request::get('insubgrp') == $search_category->slug ? 'selected' : '', false); ?>>
                          <?php echo e($search_category->name, false); ?>

                        </option>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </optgroup>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select> <!-- /.category -->
              </div> <!-- /.search-box-select -->

              <div class="search-box-input">
                <?php echo Form::text('q', Request::get('q'), ['id' => 'autoSearchInput', 'placeholder' => trans('theme.main_searchbox_placeholder'), 'autocomplete' => 'off', 'data-search']); ?>

              </div>

              <div class="search-box-button">
                <button type="submit" class="navbar-search-submit">
                  <i class="fal fa-search"></i>
                </button>
              </div>

              
              <?php if(is_incevio_package_loaded('searchAutocomplete')): ?>
                <?php echo $__env->make('searchAutocomplete::_autoComplete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
              <?php endif; ?>
            </div> <!-- /.search-box -->
            <?php echo Form::close(); ?>


            <p id="search-nav-feedabck" class="pl-4 text-danger small hide">
              <?php echo e(trans('theme.type_min_char', ['min' => 3]), false); ?>

            </p>

            
            <?php if(is_incevio_package_loaded('trendingKeywords')): ?>
              <div class="text-center trending-words">
                <?php echo $__env->make('trendingKeywords::_keyword_lists', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
              </div>
            <?php endif; ?>
          </div> <!-- /.header-search -->
        </div> <!-- /.global-search -->

        <div class="col-5 col-lg-2 mt-lg-2">
          <div class="header-utility d-flex h-100 align-items-center">
            <ul class="d-flex">
              <li class="search-btn">
                <span class="fal fa-search"></span>
              </li>

              <li>
                <a href="<?php echo e(route('account', 'account'), false); ?>">
                  <i class="fal fa-user" data-toggle="tooltip" data-placement="top" title="<?php echo e(trans('theme.your_account'), false); ?>"></i>
                  <!-- <img src="images/big-user.svg" alt=""> -->
                </a>
              </li>

              <?php if(is_incevio_package_loaded('comparison')): ?>
                <?php
                  $comparison_item = !empty(Session::get('comparables')) ? count(Session::get('comparables')) : 0;
                ?>

                <li>
                  <a href="<?php echo e(route('product.comparables'), false); ?>">
                    <i class="fal fa-balance-scale" data-toggle="tooltip" data-placement="top" title="<?php echo e(trans('theme.your_comparisons'), false); ?>"></i>
                    
                    
                    <span id="globalCompareItemCount" class="badge <?php echo e($comparison_item == 0 ? 'hidden' : '', false); ?>"><?php echo e($comparison_item, false); ?></span>
                  </a>
                </li>
              <?php endif; ?>

              <li>
                <a href="<?php echo e(route('account', 'wishlist'), false); ?>">
                  <i class="fal fa-heart" data-toggle="tooltip" data-placement="top" title="<?php echo e(trans('theme.your_wishlist'), false); ?>"></i>
                  <span id="globalWishlistItemCount" class="badge <?php echo e($wishlist_item_count == 0 ? 'hidden' : '', false); ?>"><?php echo e($wishlist_item_count, false); ?></span>
                  <!-- <img src="images/big-heart.svg" alt=""> -->
                  
                </a>
              </li>

              <li>
                <a href="<?php echo e(route('cart.index'), false); ?>">
                  <i class="fal fa-shopping-cart" data-toggle="tooltip" data-placement="top" title="<?php echo e(trans('theme.your_cart'), false); ?>"></i>
                  <!-- <img src="images/shopping-bag.svg" alt=""> -->
                  <span id="globalCartItemCount" class="badge <?php echo e($cart_item_count == 0 ? 'hidden' : '', false); ?>"><?php echo e($cart_item_count, false); ?></span>
                </a>
              </li>

              
            </ul>
          </div> <!-- /.header-utility -->
        </div> <!-- /.col-3 -->
      </div> <!-- /.row -->
    </div> <!-- /.container -->
  </div> <!-- /.header-main -->
</div> <!-- /.primary-navigation -->

<div class="primary-nav">
  <div class="container" id="primary-nav-container">
    <div class="primary-nav-inner">
      <ul class="menu-dropdown-list primary-nav-category">
        <?php if(is_null($hidden_menu_items) || !in_array('Categories', $hidden_menu_items)): ?>
          <li>
            <a href="<?php echo e(route('categories'), false); ?>" class="menu-link" data-menu-link>
              <i class="fas fa-bars mr-2"></i>
              <?php echo e(trans('theme.categories'), false); ?>

              
            </a>

            <ul class="menu-cat hide">
              <div class="menu-list-wrapper" data-simplebar>
                <div class="menu-list">
                  <?php $__currentLoopData = $all_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $catGroup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li data-category-id="<?php echo e($catGroup->id, false); ?>">
                      <a href="<?php echo e(route('categoryGrp.browse', $catGroup->slug), false); ?>">
                        <?php if($catGroup->logoImage && Storage::exists($catGroup->logoImage->path)): ?>
                          <img src="<?php echo e(get_storage_file_url($catGroup->logoImage->path, 'tiny_thumb'), false); ?>" alt="<?php echo e($catGroup->name, false); ?>">
                        <?php else: ?>
                          <i class="fal <?php echo e($catGroup->icon ?? 'fa-cube', false); ?> mb-0"></i>
                        <?php endif; ?>
                        <span><?php echo e($catGroup->name, false); ?></span>
                        <i class="fal fa-chevron-right mb-0"></i>
                      </a>
                      
                    </li>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
              </div>

              <?php $__currentLoopData = $all_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $catGroup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="mega-dropdown common-dropdown" data-simplebar data-category-id="<?php echo e($catGroup->id, false); ?>" <?php if($catGroup->backgroundImage): ?> style="background-image: url('<?php echo e(get_storage_file_url(optional($catGroup->backgroundImage)->path, 'full'), false); ?>')" <?php endif; ?>>

                  


                  <div class="row">
                    <?php $__currentLoopData = $catGroup->subGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subGroup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <div class="col-lg-4 col-xl-3 mb-2">
                        <div class="mega-dropdown-item">
                          <h3 class="mb-1">
                            <a href="<?php echo e(route('categories.browse', $subGroup->slug), false); ?>"><?php echo e($subGroup->name, false); ?></a>
                          </h3>

                          <ul>
                            <?php $__currentLoopData = $subGroup->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              <li>
                                <a href="<?php echo e(route('category.browse', $cat->slug), false); ?>"><?php echo e($cat->name, false); ?></a>
                              </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          </ul>
                        </div>
                      </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </div> <!-- ./row -->
                </div> <!-- ./mega-dropdown -->
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
          </li>
        <?php endif; ?>
      </ul>

      <ul class="header-nav-items">
        <?php if(is_null($hidden_menu_items) || !in_array('Brands', $hidden_menu_items)): ?>
          <li>
            <a class="menu-link" href="<?php echo e(route('brands'), false); ?>">
              <i class="fal fa-crown menu-icon"></i> <?php echo e(trans('theme.brands'), false); ?>

            </a>
          </li>
        <?php endif; ?>

        <?php if(is_null($hidden_menu_items) || !in_array('Vendors', $hidden_menu_items)): ?>
          <li>
            <a class="menu-link" href="<?php echo e(route('shops'), false); ?>">
              <i class="fal fa-store menu-icon"></i> <?php echo e(trans('theme.vendors'), false); ?>

            </a>
          </li>
        <?php endif; ?>

        <?php if(is_incevio_package_loaded('auction')): ?>
          <?php if(is_null($hidden_menu_items) || !in_array('auction', $hidden_menu_items)): ?>
            <li>
              <a class="menu-link" href="<?php echo e(route('auctions'), false); ?>">
                <i class="fal fa-gavel menu-icon"></i> <?php echo e(trans('packages.auction.auctions'), false); ?>

              </a>
            </li>
          <?php endif; ?>
        <?php endif; ?>

        <?php $__currentLoopData = get_main_nav_categories(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nav_cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <li>
            <a class="menu-link" href="<?php echo e(route('category.browse', $nav_cat->slug), false); ?>">
              <i class="fas fa-fire-alt menu-icon"></i> <?php echo e($nav_cat->name, false); ?>

            </a>
          </li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <?php if(is_incevio_package_loaded('eventy')): ?>
          <?php if(is_null($hidden_menu_items) || !in_array('events', $hidden_menu_items)): ?>
            <li>
              <a class="menu-link" href="<?php echo e(route('events'), false); ?>">
                <i class="fal fa-calendar-alt menu-icon"></i> <?php echo e(trans('theme.events'), false); ?>

              </a>
            </li>
          <?php endif; ?>
        <?php endif; ?>

        <?php $__currentLoopData = $pages->where('position', 'main_nav'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <li>
            <a href="<?php echo e(get_page_url($page->slug), false); ?>" class="menu-link">
              <i class="fal fa-link menu-icon"></i> <?php echo e($page->title, false); ?>

            </a>
          </li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <?php if(is_null($hidden_menu_items) || !in_array('Sale', $hidden_menu_items)): ?>
          <li>
            <a class="menu-link" href="<?php echo e(url('/selling'), false); ?>">
              <i class="fal fa-seedling menu-icon"></i>
              <?php echo e(trans('theme.nav.sell_on', ['platform' => get_platform_title()]), false); ?>

            </a>
          </li>
        <?php endif; ?>
      </ul>

      <?php if(isset($promotional_tagline['action_url'])): ?>
        <div class="shale-text">
          <a style="text-decoration: none" href="<?php echo e($promotional_tagline['action_url'] ?? 'javascript:void(0)', false); ?>">
            <p><?php echo e(!empty($promotional_tagline['text']) ? $promotional_tagline['text'] : '', false); ?></p>
          </a>
        </div>
      <?php endif; ?>
    </div>
  </div>
</div> <!-- /.primary-nav -->
<?php /**PATH /home/ddondola/public_html/public/themes/default/views/nav/main.blade.php ENDPATH**/ ?>