<?php if(isset($deal_of_the_day) && $deal_of_the_day): ?>
  <section>
    <div class="best-deal">
      <div class="container">
        <div class="best-deal-inner">
          <div class="row">
            <div class="col-xl-<?php echo e($featured_items ? '8' : '12', false); ?>">
              <div class="box-inner">
                <div class="best-deal-header">
                  <div class="sell-header">
                    <div class="sell-header-title">
                      <h2 class="mb-1">
                        <?php echo e(trans('theme.deal_of_the_day'), false); ?>

                        <i class="fal fa-calendar-day"></i>
                      </h2>
                    </div>

                    <div class="header-line">
                      <span></span>
                    </div>
                  </div>
                </div>

                <div class="deal-of-day">
                  <div class="deal-of-day-label"><?php echo e(trans('theme.hot'), false); ?></div>
                  <div class="deal-of-day-inner">
                    <div class="deal-of-day-slider deal-slider text-center">
                      <?php $__currentLoopData = $deal_of_the_day->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="deal-of-day-slider-item">
                          <img class="lazy" src="/images/square.webp" data-src="<?php echo e(get_storage_file_url($img->path, 'full'), false); ?>" alt="<?php echo e($deal_of_the_day->title, false); ?>">
                        </div>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <div class="deal-of-day-details">
                      <div class="deal-of-day-details-name">
                        <a href="<?php echo e(route('show.product', $deal_of_the_day->slug), false); ?>"><?php echo strip_tags($deal_of_the_day->title); ?></a>
                      </div>

                      <div class="deal-of-day-details-price">
                        <p>
                          <span class="regular-price">
                            <?php echo get_formated_currency($deal_of_the_day->current_sale_price(), config('system_settings.decimals', 2)); ?>

                          </span>

                          <?php if($deal_of_the_day->hasOffer()): ?>
                            <span class="old-price">
                              <?php echo get_formated_currency($deal_of_the_day->sale_price, config('system_settings.decimals', 2)); ?>

                            </span>
                          <?php endif; ?>
                        </p>
                      </div>

                      <div class="best-seller-item-rating">
                        <?php echo $__env->make('theme::partials._vertical_ratings', ['ratings' => $deal_of_the_day->ratings], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                      </div>

                      <div class="deal-of-day-details-description">
                        <p><?php echo e(substr(strip_tags($deal_of_the_day->description), 0, 100), false); ?></p>
                      </div>

                      <div class="deal-of-day-details-list">
                        <h3><?php echo e(trans('theme.key_features'), false); ?></h3>
                        <ul>
                          <?php if($feature = unserialize($deal_of_the_day->key_features)): ?>
                            <?php for($i = 0; $i < 3; $i++): ?>
                              <li>
                                <i class="fal fa-check"></i>
                                <span><?php echo e(!empty($feature[$i]) ? $feature[$i] : null, false); ?></span>
                              </li>
                            <?php endfor; ?>
                          <?php endif; ?>
                        </ul>
                      </div>

                      <div class="deal-of-day-btns mt-4">
                        <a href="javascript:void(0);" data-link="<?php echo e(route('cart.addItem', $deal_of_the_day->slug), false); ?>" class="sc-add-to-cart" tabindex="0">
                          <i class="fal fa-shopping-cart"></i>
                          <span class="d-none d-sm-inline-block"><?php echo e(trans('theme.add_to_cart'), false); ?></span>
                        </a>

                        <a href="javascript:void(0);" data-link="<?php echo e(route('wishlist.add', $deal_of_the_day), false); ?>" class="add-to-wishlist">
                          <i class="far fa-heart"></i> <?php echo e(trans('theme.button.add_to_wishlist'), false); ?>

                        </a>

                        <?php if(is_incevio_package_loaded('comparison')): ?>
                          

                          <a href="javascript:void(0);" data-link="<?php echo e(route('comparable.add', $deal_of_the_day->id), false); ?>" class="add-to-product-compare ml-3">
                            <i class="fal fa-balance-scale"></i> <?php echo app('translator')->get('theme.button.compare'); ?>
                          </a>
                        <?php endif; ?>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div> <!-- .col-lg-* -->

            <?php if($featured_items): ?>
              <div class="col-xl-4 mt-3 mt-xl-0">
                <div class="best-deal-col">
                  <div class="best-deal-header">
                    <div class="sell-header">
                      <div class="sell-header-title">
                        <h2>
                          <?php echo e(trans('theme.featured_items'), false); ?>

                          <i class="far fa-hat-cowboy"></i>
                        </h2>
                      </div>
                      <div class="header-line">
                        <span></span>
                      </div>

                      <div class="best-deal-arrow">
                        <ul>
                          <li>
                            <button class="left-arrow slider-arrow best-seller-left">
                              <i class="fal fa-chevron-left"></i>
                            </button>
                          </li>

                          <li>
                            <button class="right-arrow slider-arrow best-seller-right">
                              <i class="fal fa-chevron-right"></i>
                            </button>
                          </li>
                        </ul>
                      </div>
                    </div>
                  </div> <!-- /.best-deal-header -->

                  <div class="best-seller">
                    <div class="best-seller-slider">
                      <div class="sl">
                        <?php $__currentLoopData = $featured_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <div class="best-seller-item border-animate" data-mycount="<?php echo e($loop->iteration, false); ?>">
                            <div class="box-inner">
                              <div class="best-seller-item-image">
                                <a href="<?php echo e(route('show.product', $item->slug), false); ?>">
                                  <img class="lazy" src="/images/square.webp" data-src="<?php echo e(get_inventory_img_src($item, 'medium'), false); ?>" data-name="product_image" alt="<?php echo e($item->title, false); ?>" title="<?php echo e($item->title, false); ?>">
                                </a>
                              </div>

                              <div class="best-seller-item-details">
                                <div class="best-seller-item-details-inner">
                                  <div class="best-seller-item-name">
                                    <a href="<?php echo e(route('show.product', $item->slug), false); ?>">
                                      <?php echo e($item->title, false); ?>

                                    </a>
                                  </div>

                                  <div class="best-seller-item-rating">
                                    <?php echo $__env->make('theme::partials._vertical_ratings', ['ratings' => $item->ratings], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                  </div>

                                  <div class="best-seller-item-price">
                                    <?php echo $__env->make('theme::partials._home_pricing', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                  </div>

                                  <div class="best-seller-item-utility">
                                    <div class="box-action-price mb-1">
                                      <?php echo $__env->make('theme::partials._home_pricing', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>

                                    <div class="horizon-btns">
                                      <?php echo $__env->make('theme::partials._horizontal_action_buttons', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                  </div> <!-- /.best-seller-item-utility -->
                                </div> <!-- /.best-seller-item-details-inner -->
                              </div> <!-- /.best-seller-item-details -->
                            </div> <!-- /.box-inner -->
                          </div> <!-- /.best-seller-item -->

                          <?php if($loop->iteration % 4 === 0): ?>
                      </div> <!-- /.sl -->
                      <div class="sl">
            <?php endif; ?>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div> <!-- /.sl -->
</div> <!-- /.best-seller-slider -->
</div> <!-- /.best-seller -->
</div> <!-- /.best-deal-col -->
</div> <!-- /.col-lg-4 -->
<?php endif; ?>
</div> <!-- /.row -->
</div> <!-- /.best-deal-inner -->
</div> <!-- /.container -->
</div> <!-- /.best-deal -->
</section>
<?php elseif(isset($featured_items) && $featured_items): ?>
<section>
  <div class="neckbands">
    <div class="container">
      <div class="neckbands-inner">
        <div class="neckbands-header">
          <div class="sell-header">
            <div class="sell-header-title">
              <h2><?php echo e(trans('theme.featured'), false); ?></h2>
            </div>
            <div class="header-line">
              <span></span>
            </div>
            <div class="best-deal-arrow">
              <ul>
                <li><button class="left-arrow slider-arrow slick-arrow neckbands-left"><i class="fal fa-chevron-left"></i></button></li>
                <li><button class="right-arrow slider-arrow slick-arrow neckbands-right"><i class="fal fa-chevron-right"></i></button></li>
              </ul>
            </div>
          </div>
        </div>
        <div class="neckbands-items">
          <div class="neckbands-items-inner">
            <?php echo $__env->make('theme::partials._product_horizontal', ['products' => $featured_items], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<?php endif; ?>
<?php /**PATH /home/ddondola/public_html/public/themes/default/views/sections/deal_of_the_day.blade.php ENDPATH**/ ?>