<?php $__env->startSection('page-style'); ?>
  <?php echo $__env->make('plugins.ionic', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
  <?php echo $__env->make('admin.partials._check_misconfigured_subscription', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <div class="row dashboard-total">
    <div class="col-md-3 stretch-card grid-margin">
      <div class="card bg-gradient-danger card-img-holder text-white">
        <div class="card-body">
          <img src="/images/circle.svg" class="card-img-absolute" alt="circle-image">
          <h4 class="font-weight-normal mb-3"><?php echo e(trans('app.customers'), false); ?> <i class="icon ion-md-people float-right"></i>
          </h4>
          <h2 class="mb-5"><?php echo e($customer_count, false); ?></h2>
          <h6 class="card-text"><i class="icon ion-md-add"></i> <?php echo e(trans('app.new_in_30_days', ['new' => $new_customer_last_30_days, 'model' => trans('app.customers')]), false); ?></h6>
        </div>
      </div>
    </div>

    <div class="col-md-3 stretch-card grid-margin">
      <div class="card bg-gradient-info card-img-holder text-white">
        <div class="card-body">
          <img src="/images/circle.svg" class="card-img-absolute" alt="circle-image">
          <h4 class="font-weight-normal mb-3"><?php echo e(trans('app.merchants'), false); ?> <i class="fa fa-bar-chart-o float-right"></i>
          </h4>
          <h2 class="mb-5"><?php echo e($merchant_count, false); ?></h2>
          <h6 class="card-text"><i class="icon ion-md-add"></i> <?php echo e(trans('app.new_in_30_days', ['new' => $new_merchant_last_30_days, 'model' => trans('app.merchants')]), false); ?></h6>
        </div>
      </div>
    </div>

    <div class="col-md-3 stretch-card grid-margin">
      <div class="card bg-gradient-primary card-img-holder text-white">
        <div class="card-body">
          <img src="/images/circle.svg" class="card-img-absolute" alt="circle-image">
          <h4 class="font-weight-normal mb-3"><?php echo e(trans('app.orders'), false); ?> <i class="icon ion-md-cart float-right"></i>
          </h4>
          <h2 class="mb-5"><?php echo e($total_order_count, false); ?></h2>

          <?php
            $difference = $todays_all_order_count - $yesterdays_all_order_count;
            $todays_order_percents = $todays_all_order_count == 0 ? 0 : round(($difference / $todays_all_order_count) * 100);
          ?>

          <?php if($todays_all_order_count == 0): ?>
            <h6 class="card-text"><i class="icon ion-md-hourglass"></i> <?php echo e(trans('messages.no_orders', ['date' => trans('app.today')]), false); ?></h6>
          <?php else: ?>
            <h6 class="card-text"><i class="icon ion-md-arrow-<?php echo e($difference < 0 ? 'down' : 'up', false); ?>"></i> <?php echo e(trans('messages.todays_order_percents', ['percent' => $todays_order_percents, 'state' => $difference < 0 ? trans('app.down') : trans('app.up')]), false); ?></h6>
          <?php endif; ?>
        </div>
      </div>
    </div>

    <div class="col-md-3 stretch-card grid-margin">
      <div class="card bg-gradient-success card-img-holder text-white">
        <div class="card-body">
          <img src="/images/circle.svg" class="card-img-absolute" alt="circle-image">
          <h4 class="font-weight-normal mb-3"><?php echo e(trans('app.todays_sale'), false); ?> <i class="icon ion-md-wallet float-right"></i>
          </h4>
          <h2 class="mb-5">
            <?php echo e(get_formated_currency($todays_sale_amount, 2, config('system_settings.currency.id')), false); ?>

          </h2>

          <?php
            $difference = $todays_sale_amount - $yesterdays_sale_amount;
            $todays_sale_percents = $todays_sale_amount == 0 ? 0 : round(($difference / $todays_sale_amount) * 100);
          ?>

          <?php if($todays_sale_amount == 0): ?>
            <h6 class="card-text"><i class="icon ion-md-hourglass"></i> <?php echo e(trans('messages.no_sale', ['date' => trans('app.today')]), false); ?></h6>
          <?php else: ?>
            <h6 class="card-text"><i class="icon ion-md-arrow-<?php echo e($difference < 0 ? 'down' : 'up', false); ?>"></i> <?php echo e(trans('messages.todays_sale_percents', ['percent' => $todays_sale_percents, 'state' => $difference < 0 ? trans('app.down') : trans('app.up')]), false); ?></h6>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>

  <!-- Info boxes -->
  <div class="row">
    <div class="col-md-8 col-sm-7 col-xs-12">
      <div class="row">
        <div class="col-sm-6 col-xs-12 nopadding-right">
          <div class="info-box bg-yellow">
            <span class="info-box-icon"><i class="icon ion-md-filing"></i></span>

            <div class="info-box-content">
              <span class="info-box-text"><?php echo e(trans('app.pending_verifications'), false); ?></span>
              <span class="info-box-number">
                <?php echo e($pending_verifications, false); ?>

                <a href="<?php echo e(route('admin.vendor.shop.verifications'), false); ?>" class="pull-right" data-toggle="tooltip" data-placement="left" title="<?php echo e(trans('app.take_action'), false); ?>">
                  <i class="icon ion-md-paper-plane"></i>
                </a>
              </span>

              <div class="progress">
                <div class="progress-bar bg-warning" style="width: 0;"></div>
              </div>

              <span class="progress-description">
                <i class="icon ion-md-hourglass"></i>
                <?php echo e(trans_choice('messages.pending_verifications', $pending_verifications, ['count' => $pending_verifications]), false); ?>

              </span>
            </div><!-- /.info-box-content -->
          </div>
        </div>

        <div class="col-sm-6 col-xs-12 px-2">
          <div class="info-box bg-aqua">
            <span class="info-box-icon"><i class="icon ion-md-pulse"></i></span>

            <div class="info-box-content">
              <span class="info-box-text"><?php echo e(trans('app.pending_approvals'), false); ?></span>
              <span class="info-box-number">
                <?php echo e($pending_approvals, false); ?>

                <a href="<?php echo e(route('admin.vendor.shop.index'), false); ?>" class="pull-right" data-toggle="tooltip" data-placement="left" title="<?php echo e(trans('app.take_action'), false); ?>">
                  <i class="icon ion-md-paper-plane"></i>
                </a>
              </span>

              <div class="progress">
                <div class="progress-bar bg-info" style="width: 0;"></div>
              </div>

              <span class="progress-description">
                <i class="icon ion-md-hourglass"></i>
                <?php echo e(trans_choice('messages.pending_approvals', $pending_approvals, ['count' => $pending_approvals]), false); ?>

              </span>
            </div><!-- /.info-box-content -->
          </div>
        </div>
      </div>
    </div><!-- /.col-*-* -->

    <div class="col-md-4 col-sm-5 col-xs-12 nopadding-left">
      <div class="info-box bg-red">
        <span class="info-box-icon"><i class="icon ion-md-megaphone"></i></span>
        <div class="info-box-content">
          <span class="info-box-text"><?php echo e(trans('app.appealed_disputes'), false); ?></span>
          <span class="info-box-number">
            <?php echo e($dispute_count, false); ?>

            <a href="<?php echo e(route('admin.support.dispute.index'), false); ?>" class="pull-right" data-toggle="tooltip" data-placement="left" title="<?php echo e(trans('app.take_action'), false); ?>">
              <i class="icon ion-md-paper-plane"></i>
            </a>
          </span>

          <?php
            $last_months = $last_60days_dispute_count - $last_30days_dispute_count;
            $difference = $last_30days_dispute_count - $last_months;
            $last_30_days_percents = $last_months == 0 ? 100 : round(($difference / $last_months) * 100);
          ?>
          <div class="progress">
            <div class="progress-bar bg-danger" style="width: 0;"></div>
          </div>

          <span class="progress-description">
            <i class="icon ion-md-arrow-<?php echo e($difference > 0 ? 'up' : 'down', false); ?>"></i>
            <?php echo e(trans('messages.last_30_days_percents', ['percent' => $last_30_days_percents, 'state' => $difference > 0 ? trans('app.increase') : trans('app.decrease')]), false); ?>

          </span>
        </div>
        <!-- /.info-box-content -->
      </div>
    </div>
    <!-- /.col-*-* -->
  </div>

  <div class="row">
    <div class="col-xs-12">
      <div class="box">
        <div class="nav-tabs-custom">
          <ul class="nav nav-tabs nav-justified">
            <div class="box-header with-border">
              <h3 class="box-title"><i class="fa fa-dollar"></i>
                <?php echo e(trans('app.sales_graph'), false); ?></h3>
            </div>
          </ul> <!-- /.nav .nav-tabs -->

          <div class="tab-content total-sale-graph">
            <!-- Tab buttons for user interaction -->
            <div class="tab-container">
              <div class="tab-button active" data-timeframe="week"><?php echo e(trans('app.this_week'), false); ?></div>
              <div class="tab-button" data-timeframe="month"><?php echo e(trans('app.this_month'), false); ?></div>
              <div class="tab-button" data-timeframe="year"><?php echo e(trans('app.this_year'), false); ?></div>
            </div>

            <!-- Chart canvas container -->
            <canvas id="saleChart" height="100vh"></canvas>
          </div> <!-- /.tab-content -->
        </div> <!-- /.nav-tabs-custom -->
      </div> <!-- /.box -->
    </div>
  </div>


  <div class="row">
    <div class="col-md-8">
      <div class="box">
        <div class="nav-tabs-custom">
          <ul class="nav nav-tabs nav-justified">
            <div class="box-header with-border">
              <h3 class="box-title">
                <i class="icon ion-md-pulse hidden-sm"></i>
                <?php echo e(trans('app.visitors_graph'), false); ?>

            </div>
          </ul>
          <!-- /.nav .nav-tabs -->

          <div class="tab-content">
            <div class="tab-pane active" id="visitors_tab">
              <div><?php echo $chart->container(); ?></div>
            </div>
          </div>
          <!-- /.tab-content -->
        </div>
        <!-- /.nav-tabs-custom -->
      </div><!-- /.box -->
    </div>
    <div class="col-md-4">
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">
            <i class="fa fa-pie-chart"></i>
            <?php echo e(trans('app.catalog_graph'), false); ?>

        </div>
        <div class="donutChart" style="min-height: 340px; padding: 30px 0;">
          <canvas id="productChart" class=""></canvas>
        </div>
      </div>
    </div>
  </div>

  <div class="row dashboard-ticket-section">
    <div class="col-md-6">
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">
            <?php echo e(trans('app.open_tickets'), false); ?>

        </div>
        <table class="table table-bordered">
          <thead>
            <tr>
              <th width="65%"><?php echo e(trans('app.subject'), false); ?></th>
              <th><?php echo e(trans('app.priority'), false); ?></th>
              <th><i class="icon ion-md-chatbubbles"></i></th>
              <th><?php echo e(trans('app.updated_at'), false); ?></th>
            </tr>
          </thead>
          <tbody class="box-body">
            <?php $__empty_1 = true; $__currentLoopData = $open_tickets->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
              <tr>
                <td>
                  <span class="label label-outline"> <?php echo e($ticket->category->name, false); ?> </span>
                  <p class="indent5">
                    <a href="<?php echo e(route('admin.support.ticket.show', $ticket->id), false); ?>"><?php echo e($ticket->subject, false); ?></a>
                  </p>
                </td>
                <td><?php echo $ticket->priorityLevel(); ?></td>
                <td><span class="label label-default"><?php echo e($ticket->replies_count, false); ?></span></td>
                <td><?php echo e($ticket->updated_at->diffForHumans(), false); ?></td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
              <tr>
                <td colspan="3"><?php echo e(trans('app.no_data_found'), false); ?></td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
    <div class="col-md-3">
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">
            <?php echo e(trans('app.top_customers'), false); ?>

        </div>
        <table class="table table-bordered">
          <thead>
            <tr>
              <th><?php echo e(trans('app.name'), false); ?></th>
              <th><i class="icon ion-md-cart"></i></th>
              <th><?php echo e(trans('app.revenue'), false); ?></th>
            </tr>
          </thead>

          <tbody class="box-body">
            <?php $__empty_1 = true; $__currentLoopData = $top_customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
              <tr>
                <td>
                  <?php if($customer->image): ?>
                    <img src="<?php echo e(get_storage_file_url(optional($customer->image)->path, 'tiny'), false); ?>" class="img-circle" alt="<?php echo e(trans('app.avatar'), false); ?>">
                  <?php else: ?>
                    <img src="<?php echo e(get_gravatar_url($customer->email, 'tiny'), false); ?>" class="img-circle" alt="<?php echo e(trans('app.avatar'), false); ?>">
                  <?php endif; ?>

                  <p class="indent5">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view', $customer)): ?>
                      <a href="javascript:void(0)" data-link="<?php echo e(route('admin.admin.customer.show', $customer->id), false); ?>" class="ajax-modal-btn modal-btn">
                        <?php echo e($customer->getName(), false); ?>

                      </a>
                    <?php else: ?>
                      <?php echo e($customer->getName(), false); ?>

                    <?php endif; ?>
                  </p>
                </td>

                <td>
                  <span class="label label-outline"><?php echo e($customer->orders_count, false); ?></span>
                </td>

                <td>
                  <?php echo e(get_formated_currency(round($customer->orders->sum('total')), 2, config('system_settings.currency.id')), false); ?>

                </td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

              <tr>
                <td colspan="3"><?php echo e(trans('app.no_data_found'), false); ?></td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>

    <div class="col-md-3">
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">
            <?php echo e(trans('app.top_vendors'), false); ?>

        </div>
        <table class="table table-bordered">
          <thead>
            <tr>
              <th><?php echo e(trans('app.name'), false); ?></th>
              <th><i class="icon ion-md-cart"></i></th>
              <th><?php echo e(trans('app.revenue'), false); ?></th>
            </tr>
          </thead>
          <tbody class="box-body">
            <?php $__empty_1 = true; $__currentLoopData = $top_vendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
              <tr>
                <td>
                  <img src="<?php echo e(get_storage_file_url(optional($vendor->logoImage)->path, 'tiny'), false); ?>" class="img-circle" alt="<?php echo e(trans('app.logo'), false); ?>">
                  <p class="indent5">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view', $vendor)): ?>
                      <a href="javascript:void(0)" data-link="<?php echo e(route('admin.vendor.shop.show', $vendor->id), false); ?>" class="ajax-modal-btn modal-btn"><?php echo e($vendor->name, false); ?></a>
                    <?php else: ?>
                      <?php echo e($vendor->name, false); ?>

                    <?php endif; ?>
                  </p>
                </td>
                <td>
                  <span class="label label-outline"><?php echo e($vendor->inventories_count, false); ?></span>
                </td>
                <td>
                  <?php echo e($vendor->lifetime_value, false); ?>

                </td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
              <tr>
                <td colspan="3"><?php echo e(trans('app.no_data_found'), false); ?></td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
  <div class="row dashboard-product-section">
    <div class="col-md-6">
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">
            <?php echo e(trans('app.top_sale_products'), false); ?>

        </div>
        <table class="table table-bordered">
          <thead>
            <tr>
              <th><?php echo e(trans('app.image'), false); ?></th>
              <th><?php echo e(trans('app.name'), false); ?></th>
              <th><?php echo e(trans('app.sold'), false); ?></th>
              <th><?php echo e(trans('app.gtin'), false); ?></th>
              <th><?php echo e(trans('app.action'), false); ?></th>
            </tr>
          </thead>
          <tbody class="box-body">
            <?php $__currentLoopData = $top_selling_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><img src="<?php echo e(get_storage_file_url(optional($product->featureImage)->path, 'tiny'), false); ?>" alt="<?php echo e($product->name, false); ?>" class="img-thumbnail"></td>
                <td><a href="javascript:void(0)" data-link="<?php echo e(route('admin.catalog.product.show', $product->id), false); ?>" class="ajax-modal-btn">
                    <?php echo e($product->name, false); ?>

                  </a></td>
                <td><span class="label label-outline"><?php echo e($product->inventories_sum_sold_quantity, false); ?></span></td>
                <td><span class="label label-outline"><?php echo e($product->gtin_type, false); ?></span> <?php echo e($product->gtin, false); ?></td>
                <td>
                  <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $product)): ?>
                    <a class="btn btn-primary" href="<?php echo e(route('admin.catalog.product.edit', $product->id), false); ?>"><i data-toggle="tooltip" data-placement="top" title="<?php echo e(trans('app.edit'), false); ?>" class="fa fa-edit"></i></a>
                  <?php endif; ?>
                </td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    </div>
    <div class="col-md-6">
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">
            <?php echo e(trans('app.recently_added_products'), false); ?>

        </div>
        <table class="table table-bordered">
          <thead>
            <tr>
              <th><?php echo e(trans('app.image'), false); ?></th>
              <th><?php echo e(trans('app.name'), false); ?></th>
              <th><?php echo e(trans('app.sold'), false); ?></th>
              <th><?php echo e(trans('app.gtin'), false); ?></th>
              <th><?php echo e(trans('app.action'), false); ?></th>
            </tr>
          </thead>
          <tbody class="box-body">
            <?php $__currentLoopData = $latest_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><img src="<?php echo e(get_storage_file_url(optional($product->featureImage)->path, 'tiny'), false); ?>" alt="<?php echo e($product->name, false); ?>" class="img-thumbnail"></td>
                <td><a href="javascript:void(0)" data-link="<?php echo e(route('admin.catalog.product.show', $product->id), false); ?>" class="ajax-modal-btn">
                    <?php echo e($product->name, false); ?>

                  </a></td>
                <td><span class="label label-outline"><?php echo e($product->inventories_sum_sold_quantity, false); ?></span></td>
                <td><span class="label label-outline"><?php echo e($product->gtin_type, false); ?></span> <?php echo e($product->gtin, false); ?></td>
                <td>
                  <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $product)): ?>
                    <a class="btn btn-primary" href="<?php echo e(route('admin.catalog.product.edit', $product->id), false); ?>"><i data-toggle="tooltip" data-placement="top" title="<?php echo e(trans('app.edit'), false); ?>" class="fa fa-edit"></i></a>
                  <?php endif; ?>
                </td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>

  <div class="row dashboard-product-section">
    <div class="col-md-6">
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">
            <?php echo e(trans('app.top_sale_brands'), false); ?>

        </div>
        <table class="table table-bordered">
          <thead>
            <tr>
              <th><?php echo e(trans('app.image'), false); ?></th>
              <th><?php echo e(trans('app.name'), false); ?></th>
              <th><?php echo e(trans('app.sold'), false); ?></th>
              <th><?php echo e(trans('app.country'), false); ?></th>
              <th><?php echo e(trans('app.action'), false); ?></th>
            </tr>
          </thead>
          <tbody class="box-body">
            <?php $__currentLoopData = $top_selling_brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $manufacturer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><img src="<?php echo e(get_logo_url($manufacturer, 'tiny'), false); ?>" class="img-sm" alt="<?php echo e(trans('app.image'), false); ?>"></td>
                <td><a href="#" class="ajax-modal-btn">
                    <?php echo e($manufacturer->name, false); ?>

                  </a></td>
                <td><span class="label label-outline"><?php echo e($manufacturer->inventories_sum_sold_quantity, false); ?></span></td>
                <td><?php echo e(optional($manufacturer->country)->name, false); ?></td>
                <td>
                  <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $manufacturer)): ?>
                    <a href="javascript:void(0)" data-link="<?php echo e(route('admin.catalog.manufacturer.edit', $manufacturer->id), false); ?>" class="ajax-modal-btn btn btn-primary"><i data-toggle="tooltip" data-placement="top" title="<?php echo e(trans('app.edit'), false); ?>" class="fa fa-edit"></i></a>&nbsp;
                  <?php endif; ?>
                </td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    </div>
    <div class="col-md-6">
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">
            <?php echo e(trans('app.top_sale_categories'), false); ?>

        </div>
        <table class="table table-bordered">
          <thead>
            <tr>
              <th><?php echo e(trans('app.image'), false); ?></th>
              <th><?php echo e(trans('app.name'), false); ?></th>
              <th><?php echo e(trans('app.sold'), false); ?></th>
              <th><?php echo e(trans('app.parent'), false); ?></th>
              <th><?php echo e(trans('app.action'), false); ?></th>
            </tr>
          </thead>
          <tbody class="box-body">
            <?php $__currentLoopData = $top_selling_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><img src="<?php echo e(get_storage_file_url(optional($category->featureImage)->path, 'tiny'), false); ?>" alt="<?php echo e($category->name, false); ?>" class="img-thumbnail"></td>
                <td><a href="#" class="ajax-modal-btn">
                    <?php echo e($category->name, false); ?>

                  </a></td>
                <td><span class="label label-outline"><?php echo e($category->listings_sum_sold_quantity, false); ?></span></td>
                <td><?php echo e($category->subGroup->name, false); ?> <i class="fa fa-angle-double-right small"></i> <?php echo e($category->subGroup->group->name, false); ?></td>
                <td>
                  <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $category)): ?>
                    <a href="javascript:void(0)" data-link="<?php echo e(route('admin.catalog.category.edit', $category->id), false); ?>" class="ajax-modal-btn btn btn-primary"><i data-toggle="tooltip" data-placement="top" title="<?php echo e(trans('app.edit'), false); ?>" class="fa fa-edit"></i></a>&nbsp;
                  <?php endif; ?>
                </td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
  <?php echo $__env->make('plugins.chart', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <?php echo $chart->script(); ?>


  <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.2.2/Chart.min.js"></script>
  <script>
    var ctx = document.getElementById("productChart").getContext('2d');
    var productChart = new Chart(ctx, {
      type: 'doughnut',
      data: {
        labels: ["<?php echo e(trans('app.admin'), false); ?>", "<?php echo e(trans('app.merchant'), false); ?>", "<?php echo e(trans('app.total'), false); ?>"],
        datasets: [{
          backgroundColor: [
            "#f39c12",
            "#ef486a",
            "#0abb75"
          ],
          data: [<?= $admin_created_total_product_count ?>, <?= $merchant_created_total_product_count ?>, <?= $admin_created_total_product_count + $merchant_created_total_product_count ?>]
        }]
      }
    });
  </script>

  <script>
    // Sample data for last week, last month, and last year
    const dataThisWeek = <?= $total_weekly_sale_report ?>;
    const dataThisMonth = <?= $total_monthly_sale_report ?>;
    const dataThisYear = <?= $total_yearly_sale_report ?>;

    // Initialize the chart with data for the last week
    const saleCtx = document.getElementById('saleChart').getContext('2d');
    const saleChart = new Chart(saleCtx, {
      type: 'line',
      data: {
        labels: <?= \App\Helpers\CharttHelper::getSaleAmount('week') ?>, // Adjust labels as needed
        datasets: [{
          label: "<?php echo app('translator')->get('app.this_week'); ?>",
          data: dataThisWeek,
          backgroundColor: '#CAD8F8',
          borderColor: '#225DE4',
          borderWidth: 2,
          pointRadius: 4,
        }]
      },
      options: {
        // Chart options here
      }
    });

    // Function to update the chart with new data based on the selected time frame
    function updateChart(timeframe, data, color) {
      saleChart.data.datasets[0].label = `This ${timeframe.charAt(0).toUpperCase() + timeframe.slice(1)}`;
      saleChart.data.datasets[0].data = data;
      saleChart.data.datasets[0].borderColor = "#225DE4";
      saleChart.data.datasets[0].backgroundColor = color;
      saleChart.data.datasets[0].pointRadius = 4;

      saleChart.data.labels = getLabels(timeframe); // Update labels based on the selected time frame
      saleChart.update();
    }

    // Helper function to get labels based on the selected time frame
    function getLabels(timeframe) {
      switch (timeframe) {
        case 'week':
          return <?= \App\Helpers\CharttHelper::getSaleAmount('week') ?>;
        case 'month':
          return <?= \App\Helpers\CharttHelper::getSaleAmount('month') ?>;
        case 'year':
          return <?= \App\Helpers\CharttHelper::getSaleAmount('year') ?>;
        default:
          return [];
      }
    }

    // Add event listeners to tab buttons for user interaction
    document.querySelectorAll('.tab-button').forEach(tabButton => {
      tabButton.addEventListener('click', () => {
        const timeframe = tabButton.getAttribute('data-timeframe');
        const data = getDataForTimeframe(timeframe); // Replace with your data retrieval logic
        const color = getColorForTimeframe(timeframe); // Adjust color as needed
        updateChart(timeframe, data, color);

        // Toggle the 'active' class among tabs
        document.querySelectorAll('.tab-button').forEach(tab => {
          tab.classList.remove('active');
        });
        tabButton.classList.add('active');
      });
    });

    // Function to retrieve data based on the selected time frame
    function getDataForTimeframe(timeframe) {
      switch (timeframe) {
        case 'week':
          return dataThisWeek;
        case 'month':
          return dataThisMonth;
        case 'year':
          return dataThisYear;
        default:
          return [];
      }
    }

    // Function to get a color based on the selected time frame
    function getColorForTimeframe(timeframe) {
      switch (timeframe) {
        case 'week':
          return '#CAD8F8';
        case 'month':
          return '#CAD8F8';
        case 'year':
          return '#CAD8F8';
        default:
          return '';
      }
    }
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ddondola/public_html/resources/views/admin/dashboard/platform.blade.php ENDPATH**/ ?>