<?php if($flashdeals): ?>
  <section id="flash-deal" class="mb-3">
    <div class="flash-deal pt-0">
      <div class="container">
        <div class="flash-deal-inner">
          <?php if (! (empty($flashdeals['listings']))): ?>
            <div class="sell-header">
              <div class="sell-header-title">
                <h2 class="font-weight-bold">
                  <?php echo e(trans('theme.flash_deal'), false); ?>

                  <i class="fal fa-flash"></i>
                </h2>
              </div>

              <div class="flash-sell-timer">
                <span class="mr-2">
                  <?php echo e(trans('theme.offer_end_in'), false); ?> :
                </span>

                <div class="flash-sell-timer-time rounded">
                  <span class="deal-counter-days">0</span> <?php echo e(trans('theme.flash_deal_days'), false); ?> : <span class="deal-counter-hours">00</span> <?php echo e(trans('theme.hrs'), false); ?> : <span class="deal-counter-minutes">00</span> <?php echo e(trans('theme.mins'), false); ?> : <span class="deal-counter-seconds">00</span> <?php echo e(trans('theme.sec'), false); ?>

                </div>
              </div>

              <div class="header-line">
                <span></span>
              </div>

              <div class="best-deal-arrow">
                <ul>
                  <li>
                    <button class="left-arrow slider-arrow slick-arrow flashdeal-left"><i class="fal fa-chevron-left"></i></button>
                  </li>

                  <li>
                    <button class="right-arrow slider-arrow slick-arrow flashdeal-right"><i class="fal fa-chevron-right"></i></button>
                  </li>
                </ul>
              </div>
            </div>

            <div class="flashdeal mb-3">
              <div class="recent-inner">
                <div class="recent-items">
                  <div class="flashdeal-items-inner">

                    <?php echo $__env->make('theme::partials._product_horizontal', ['products' => $flashdeals['listings']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                  </div>
                </div>
              </div> <!-- /.recent-inner -->
            </div>
          <?php endif; ?>

          <!-- Feathered flash deal start -->
          <div class="flash-deal-product-main">
            <div class="row justify-content-center">
              <?php if (! (empty($flashdeals['featured']))): ?>
                <?php $__currentLoopData = $flashdeals['featured']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <div class="col-12 col-md-6 col-sm-9 my-3">
                    <div class="flash-deal-product" style="<?php echo e(empty($flashdeals['products']) ? 'margin-top: 0' : '', false); ?>">
                      <div class="flash-deal-product-inner">
                        <a class="flash-deal-product-name" href="<?php echo e(route('show.product', $item->slug), false); ?>">
                          <?php echo e($item->title, false); ?>

                        </a>

                        <div class="flash-deal-product-image">
                          <div class="flash-deal-product-badge">
                            <span><?php echo e($item->condition, false); ?></span>
                          </div>

                          <a href="<?php echo e(route('show.product', $item->slug), false); ?>">
                            <img class="lazy" src="/images/square.webp" data-src="<?php echo e(get_inventory_img_src($item, 'full'), false); ?>" data-name="product_image" alt="<?php echo e($item->title, false); ?>" title="<?php echo e($item->title, false); ?>">
                          </a>

                          
                        </div>

                        <div class="flash-deal-product-details">
                          

                          <div class="flash-deal-product-price">
                            <span class="currant-price"><?php echo get_formated_currency($item->current_sale_price(), config('system_settings.decimals', 2)); ?></span>

                            <?php if($item->hasOffer()): ?>
                              <span class="old-price ml-1"><?php echo get_formated_currency($item->sale_price, config('system_settings.decimals', 2)); ?></span>

                              <span class="offer ml-3">
                                <?php echo e(trans('theme.percent_off', ['value' => $item->discount_percentage()]), false); ?>


                                
                              </span>
                            <?php endif; ?>
                          </div> <!-- /.flash-deal-product-price -->

                          <div class="flash-deal-product-description">
                            <p><?php echo $item->description; ?></p>
                          </div>

                          <div class="flash-deal-product-rating">
                            <?php echo $__env->make('theme::partials._vertical_ratings', ['ratings' => $item->ratings], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                          </div>

                          <div class="flash-deal-product-availability">
                            <span><?php echo e(trans('theme.availability'), false); ?>:</span>
                            <p><?php echo e(trans('theme.stock', ['stock' => $item->stock_quantity]), false); ?></p>
                          </div>

                          <div class="flash-deal-product-sell-time">
                            <h3>
                              <span>
                                <span class="deal-counter-days">0</span><br> <?php echo e(trans('theme.flash_deal_days'), false); ?>

                              </span>
                              <span class="spacing">:</span>
                              <span>
                                <span class="deal-counter-hours">00</span><br>
                                <?php echo e(trans('theme.hrs'), false); ?>

                              </span>
                              <span class="spacing">:</span>
                              <span>
                                <span class="deal-counter-minutes">00</span><br>
                                <?php echo e(trans('theme.mins'), false); ?>

                              </span>
                              <span class="spacing">:</span>
                              <span>
                                <span class="deal-counter-seconds">00</span><br>
                                <?php echo e(trans('theme.sec'), false); ?>

                              </span>
                            </h3>
                          </div>
                        </div> <!-- /.flash-deal-product-details -->

                        <div class="flash-deal-product-utility">

                          <?php echo $__env->make('theme::partials._horizontal_action_buttons', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        </div>
                      </div> <!-- Product inner End-->
                    </div> <!-- Product End-->
                  </div> <!-- /.col-12 -->
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php endif; ?>
            </div> <!-- /.row -->
          </div> <!-- Feathered flash deal end -->
        </div>
      </div>
    </div>
  </section>
<?php endif; ?>
<?php /**PATH /home/ddondola/public_html/public/themes/default/views/sections/flash_deals.blade.php ENDPATH**/ ?>