<style type="text/css">
  #consentBox {
    position: fixed;
    bottom: 0px;
    left: 0px;
    background: #f3f3f3;
    padding: 20px;
    border-radius: 15px;
    box-shadow: 0 8px 16px rgba(0, 0, 0, 0.3);
    text-align: center;
    z-index: 9999;
  }

  #consentBox.hide {
    opacity: 0;
    pointer-events: none;
    transform: scale(0.8);
    transition: all 0.3s ease;
  }

  ::selection {
    color: #fff;
    background: #229a0f;
  }

  #consentContent p {
    color: #858585;
    margin: 10px 0 20px 0;
  }

  #consentContent .buttons {
    display: flex;
    align-items: center;
    justify-content: center;
    margin-top: 20px;
  }

  .consentButton,
  .rejectButton {
    padding: 12px 30px;
    border: none;
    outline: none;
    color: #fff;
    font-size: 16px;
    font-weight: 500;
    border-radius: 5px;
    cursor: pointer;
    transition: all 0.3s ease;
  }

  .consentButton {
    background: var(--primary-color);
    margin-right: 10px;
  }

  .rejectButton {
    color: #111211;
    background: transparent;
    border: 2px solid var(--primary-color);
    text-decoration: none;
  }
</style>

<div id="consentBox">
  <div id="consentContent">
    <p>
      <?php echo trans('app.cookie_consent_message'); ?>

      <a href="<?php echo e(get_page_url(\App\Models\Page::PAGE_PRIVACY_POLICY), false); ?>" target="_blank"><?php echo e(trans('app.cookies_terms'), false); ?></a>
    </p>

    <div class="buttons">
      <button class="consentButton">
        <?php echo e(trans('app.cookie_consent_agree'), false); ?>

      </button>

      <button class="rejectButton">
        <?php echo e(trans('app.reject'), false); ?>

      </button>
    </div>
  </div>
</div>

<script>
  const consentBox = document.getElementById("consentBox");
  const acceptBtn = document.querySelector(".consentButton");
  const rejectBtn = document.querySelector(".rejectButton");
  const domain = "<?php echo e(config('session.domain') ?? request()->getHost(), false); ?>";
  const cookieName = "<?php echo e(config('gdpr.cookie.name'), false); ?>";

  // When accept
  acceptBtn.onclick = () => {
    setCookie(cookieName, 'accept', <?php echo e(config('gdpr.cookie.lifetime'), false); ?>);
    hideCookieDialog();
  };

  // When reject
  rejectBtn.onclick = () => {
    setCookie(cookieName, 'reject', 1);
    hideCookieDialog();
  };

  function setCookie(name, value, expirationInDays) {
    const date = new Date();
    date.setTime(date.getTime() + (expirationInDays * 24 * 60 * 60 * 1000));

    document.cookie = name + '=' + value +
      ';expires=' + date.toUTCString() +
      ';domain=' + domain +
      ';path=/<?php echo e(config('session.secure') ? ';secure' : null, false); ?>';
  }

  function hideCookieDialog() {
    if (document.cookie) {
      consentBox.classList.add("hide");
    } else {
      alert("Cookie can't be set! Please" + " unblock this site from the cookie" + " setting of your browser.");
    }
  }

  let checkCookie = document.cookie.indexOf(cookieName);
  checkCookie !== -1 ? consentBox.classList.add("hide") : consentBox.classList.remove("hide");
</script>
<?php /**PATH /home/ddondola/public_html/resources/views/cookie_consent.blade.php ENDPATH**/ ?>