<?php $__env->startSection('content'); ?>
  <?php if(is_incevio_package_loaded('otp-login')): ?>
    <?php echo $__env->make('otp-login::admin_login', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <?php else: ?>
    <div class="box">
      <div class="login-section">
        <div class="form-container">
          <div class="image-holder"></div>
          <div class="login-form-section">
            <div class="login-logo">
              <a href="<?php echo e(url('/'), false); ?>">
                <img src="<?php echo e(get_logo_url('system', 'full'), false); ?>" class="brand-logo" height="47px" alt="<?php echo e(trans('theme.logo'), false); ?>" title="<?php echo e(trans('theme.logo'), false); ?>">
              </a>
            </div>

            <div class="form-section">
              <h3 class="text-center mt-0"><?php echo e(trans('app.login'), false); ?></h3>

              <?php echo Form::open(['route' => 'login', 'id' => 'form', 'data-toggle' => 'validator']); ?>

              <div class="form-group has-feedback">
                <?php echo Form::email('email', null, ['id' => 'email', 'class' => 'form-control input-lg', 'placeholder' => trans('app.form.email_address'), 'required']); ?>

                <span class="glyphicon glyphicon-envelope form-control-feedback"></span>
                <div class="help-block with-errors"></div>
              </div>

              <div class="form-group has-feedback">
                <?php echo Form::password('password', ['id' => 'password', 'class' => 'form-control input-lg', 'id' => 'password', 'placeholder' => trans('app.form.password'), 'data-minlength' => '6', 'required']); ?>

                <span class="glyphicon glyphicon-lock form-control-feedback"></span>
                <div class="help-block with-errors"></div>
              </div>

              <div class="row">
                <div class="col-sm-6">
                  <div class="form-group">
                    <label>
                      <?php echo Form::checkbox('remember', null, null, ['class' => 'icheck']); ?> <?php echo e(trans('app.form.remember_me'), false); ?>

                    </label>
                  </div>
                </div> <!-- /.col-* -->

                <div class="col-sm-6">
                  <?php if (! (is_incevio_package_loaded('otp-login'))): ?>
                    <a class="btn btn-link pull-right nopadding-right" href="<?php echo e(route('password.request'), false); ?>"><?php echo e(trans('app.form.forgot_password'), false); ?></a>
                  <?php endif; ?>
                </div> <!-- /.col-* -->
              </div> <!-- /.row -->

              <?php echo Form::submit(trans('app.form.login'), ['class' => 'btn btn-block btn-lg btn-flat btn-primary']); ?>


              <?php echo Form::close(); ?>


              <div class="spacer20"></div>

              <a class="btn btn-link nopadding-left" href="<?php echo e(route('vendor.register'), false); ?>" class="text-center">
                <i class="fa fa-laptop" aria-hidden="true"></i> <?php echo e(customer_can_register() ? trans('app.form.register_as_merchant') : trans('app.form.register'), false); ?>

              </a>
            </div> <!-- /.form-section -->
            <?php echo $__env->make('partials._demo_admin_login', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
          </div> <!-- /.login-form-section -->
        </div> <!-- /.form-container -->
      </div> <!-- /.login-section -->
    </div> <!-- /.box -->
  <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('auth.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ddondola/public_html/resources/views/auth/login.blade.php ENDPATH**/ ?>