<footer>
  <div class="footer">
    <div class="container">
      <div class="footer-inner">
        <div class="footer-newsletter-box">
          <div class="row">
            <div class="col-lg-6 col-12">
              <div class="footer-newsletter-box-content">
                <div class="footer-newsletter-box-icon">
                  <img src="<?php echo e(theme_asset_url('img/mail.png'), false); ?>" alt="">
                </div>

                <div class="footer-newsletter-box-text">
                  <h3><?php echo e(trans('theme.newsletter_subscribe'), false); ?></h3>
                  <p class="mt-2"><?php echo e(trans('theme.newsletter_description'), false); ?></p>
                </div>
              </div>
            </div> <!-- /.col-lg-6 col-12 -->

            <div class="col-lg-6 col-12">
              <div class="footer-newsletter-box-form">
                <?php echo Form::open(['route' => 'newsletter.subscribe', 'class' => 'form-inline subscribe-form', 'id' => 'form', 'data-toggle' => 'validator']); ?>

                <div class="footer-newsletter-box-form-box">
                  <?php echo Form::email('email', null, ['placeholder' => trans('theme.placeholder.email'), 'required']); ?>

                  <button type="submit"><?php echo e(trans('theme.button.subscribe'), false); ?></button>
                </div>
                <?php echo Form::close(); ?>

              </div>
            </div> <!-- /.col-lg-6 col-12 -->
          </div> <!-- /.row -->
        </div> <!-- /.footer-newsletter-box -->

        <div class="footer-content">
          <div class="row">
            <div class="col-lg-3 col-md-4 col-sm-6 col-12">
              <div class="footer-content-box">
                <div class="footer-content-box-inner footer-brand-info">
                  <div class="footer-logo">
                    <a href="<?php echo e(url('/'), false); ?>">
                      <img src="<?php echo e(get_logo_url('system', 'logo'), false); ?>" class="brand-logo" alt="<?php echo e(trans('app.logo'), false); ?>" title="<?php echo e(trans('app.logo'), false); ?>">
                    </a>
                  </div>

                  <div class="footer-content-box-text">
                    <p><?php echo config('system_settings.slogan'); ?></p>
                  </div>

                  <div class="footer-content-box-location">
                    <div class="d-flex">
                      <i class="fas fa-map-marker-alt"></i>
                      <p><?php echo get_platform_address_string(); ?></p>
                    </div>
                  </div>

                  <?php if(config('system_settings.support_phone')): ?>
                    <div class="footer-content-box-number">
                      <a href="tel: <?php echo config('system_settings.support_phone'); ?>">
                        <i class="fas fa-phone-alt"></i><?php echo config('system_settings.support_phone'); ?>

                      </a>
                    </div>
                  <?php endif; ?>

                  <?php if(config('system_settings.support_email')): ?>
                    <div class="footer-content-box-number">
                      <a href="mailto:<?php echo config('system_settings.support_email'); ?>">
                        <i class="fas fa-at"></i><?php echo config('system_settings.support_email'); ?>

                      </a>
                    </div>
                  <?php endif; ?>

                  <div class="footer-content-box-website">
                    <a href="<?php echo e(url('/'), false); ?>"><i class="fas fa-globe-asia"></i><?php echo e(config('app.url'), false); ?></a>
                  </div>
                </div>
              </div>
            </div>

            <div class="col-lg-2 col-md-4  col-sm-6 col-6">
              <div class="footer-content-box">
                <div class="footer-content-box-inner">
                  <div class="footer-content-box-title">
                    <h3><?php echo e(trans('theme.nav.let_us_help'), false); ?></h3>
                  </div>
                  <div class="footer-content-box-links">
                    <ul>
                      <li>
                        <a href="<?php echo e(route('account', 'dashboard'), false); ?>" rel="nofollow"><?php echo e(trans('theme.nav.your_account'), false); ?></a>
                      </li>

                      <li>
                        <a href="<?php echo e(route('account', 'orders'), false); ?>" rel="nofollow"><?php echo e(trans('theme.nav.your_orders'), false); ?></a>
                      </li>

                      <?php $__currentLoopData = $pages->where('position', 'footer_1st_column'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li>
                          <a href="<?php echo e(get_page_url($page->slug), false); ?>" rel="nofollow noopener" target="_blank">
                            <?php echo e($page->title, false); ?>

                          </a>
                        </li>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                      <li>
                        <a href="<?php echo e(route('blog'), false); ?>" target="_blank" rel="noopener"><?php echo e(trans('theme.nav.blog'), false); ?></a>
                      </li>
                    </ul>
                  </div> <!-- /.footer-content-box-links -->
                </div> <!-- /.footer-content-box-inner -->
              </div> <!-- /.footer-content-box -->
            </div>

            <div class="col-lg-2 col-md-4  col-sm-6 col-6">
              <div class="footer-content-box">
                <div class="footer-content-box-inner">
                  <div class="footer-content-box-title">
                    <h3><?php echo e(trans('theme.nav.make_money'), false); ?></h3>
                  </div>
                  <div class="footer-content-box-links">
                    <ul>
                      <li>
                        <a href="<?php echo e(url('/selling'), false); ?>"><?php echo e(trans('theme.nav.sell_on', ['platform' => get_platform_title()]), false); ?></a>
                      </li>
                      <li>
                        <a href="<?php echo e(url('/selling#pricing'), false); ?>"><?php echo e(trans('theme.nav.become_merchant'), false); ?></a>
                      </li>
                      <?php if(is_incevio_package_loaded('affiliate')): ?>
                        <li>
                          <a href="<?php echo e(route('affiliate.register.form'), false); ?>"><?php echo e(trans('packages.affiliate.become_an_affiliate'), false); ?></a>
                        </li>
                      <?php endif; ?>
                      <li>
                        <a href="<?php echo e(url('/selling#howItWorks'), false); ?>"><?php echo e(trans('theme.nav.how_it_works'), false); ?></a>
                      </li>
                      <?php $__currentLoopData = $pages->where('position', 'footer_2nd_column'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li>
                          <a href="<?php echo e(get_page_url($page->slug), false); ?>" rel="nofollow" target="_blank" rel="noopener">
                            <?php echo e($page->title, false); ?>

                          </a>
                        </li>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      <li>
                        <a href="<?php echo e(url('/selling#faqs'), false); ?>" rel="nofollow"><?php echo e(trans('theme.nav.faq'), false); ?></a>
                      </li>
                    </ul>
                  </div> <!-- /.footer-content-box-links -->
                </div> <!-- /.footer-content-box-inner -->
              </div> <!-- /.footer-content-box -->
            </div>

            <div class="col-lg-2 col-md-4  col-sm-6 col-6">
              <div class="footer-content-box">
                <div class="footer-content-box-inner">
                  <div class="footer-content-box-title">
                    <h3><?php echo e(trans('theme.nav.customer_service'), false); ?></h3>
                  </div>
                  <div class="footer-content-box-links">
                    <ul>
                      <li>
                        <a href="<?php echo e(route('account', 'disputes'), false); ?>"><?php echo e(trans('theme.nav.refunds_disputes'), false); ?></a>
                      </li>
                      <li>
                        <a href="<?php echo e(route('account', 'orders'), false); ?>"><?php echo e(trans('theme.nav.contact_seller'), false); ?></a>
                      </li>
                      <?php $__currentLoopData = $pages->where('position', 'footer_3rd_column'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li>
                          <a href="<?php echo e(get_page_url($page->slug), false); ?>" rel="nofollow" target="_blank" rel="noopener">
                            <?php echo e($page->title, false); ?>

                          </a>
                        </li>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                  </div> <!-- /.footer-content-box-links -->
                </div> <!-- /.footer-content-box-inner -->
              </div> <!-- /.footer-content-box -->
            </div>

            <div class="col-lg-3 col-md-4  col-sm-6 col-6">
              <div class="footer-content-box">
                <div class="footer-content-box-inner">
                  <div class="footer-content-box-title">
                    <h3><?php echo e(trans('theme.stay_connected'), false); ?></h3>
                  </div>

                  <?php if($social_media_links = get_social_media_links()): ?>
                    <div class="footer-content-box-social">
                      <ul>
                        <?php $__currentLoopData = $social_media_links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social_media => $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <li>
                            <a href="<?php echo e($link, false); ?>" target="_blank" rel="noopener">
                              <i class="fa fa-<?php echo e($social_media, false); ?>"></i>
                            </a>
                          </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </ul>

                      <?php if($trust_badge = get_trust_badge_url()): ?>
                        <div class="mt-4 mb-2">
                          <img src="<?php echo e($trust_badge, false); ?>" />
                        </div>
                      <?php endif; ?>
                    </div> <!-- /.footer-content-box-social -->
                  <?php endif; ?>
                </div> <!-- /.footer-content-box-inner -->
              </div> <!-- /.footer-content-box -->
            </div> <!-- /.col-lg-3 -->
          </div> <!-- /.row -->
        </div> <!-- /.footer-content -->
      </div> <!-- /.footer-inner -->
    </div> <!-- /.container -->
  </div> <!-- /.footer -->
</footer>

<!-- COPYRIGHT AREA -->
<?php echo $__env->make('theme::nav.copyright', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/ddondola/public_html/public/themes/default/views/nav/footer.blade.php ENDPATH**/ ?>