<!DOCTYPE html>
<html class="no-js" lang="<?php echo e(str_replace('_', '-', app()->getLocale()), false); ?>">

<head>
  <?php echo $__env->make('meta', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <link rel="canonical" href="<?php echo e(url()->current(), false); ?>">

  <!-- Main custom css -->
  <link href="<?php echo e(theme_asset_url('css/vendors.css'), false); ?>" media="screen" rel="stylesheet">
  <link href="<?php echo e(theme_asset_url('css/style.css'), false); ?>" media="screen" rel="stylesheet">

  <?php if(config('active_locales') && config('active_locales')->firstWhere('code', App::getLocale())->rtl): ?>
    <link href="<?php echo e(theme_asset_url('css/rtl.css'), false); ?>" media="screen" rel="stylesheet">
  <?php endif; ?>

  <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  

  
  <?php if(Request::is('shop/*') && isset($shop) && get_custom_css($shop->id)): ?>
    <style>
      <?php echo e(get_custom_css($shop->id), false); ?>

    </style>
  <?php endif; ?>

  
  <?php if(get_custom_css()): ?>
    <style>
      <?php echo e(get_custom_css(), false); ?>

    </style>
  <?php endif; ?>

  <?php if(is_incevio_package_loaded('otp-login')): ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/css/intlTelInput.css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/intlTelInput.min.js"></script>
  <?php endif; ?>

  <style>
    .iti {
      display: block;
    }
  </style>

  <link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css">
</head>

<body class="<?php echo e(config('active_locales')->firstWhere('code', App::getLocale())->rtl ? 'rtl' : 'ltr', false); ?>">

  <!-- Google Tag Manager (noscript) -->
  <?php if(config('services.google.gtm_container_id')): ?>
    <noscript>
      <iframe src="https://www.googletagmanager.com/ns.html?id=<?php echo e(config('services.google.gtm_container_id'), false); ?>" height="0" width="0" style="display:none;visibility:hidden"></iframe>
    </noscript>
  <?php endif; ?>
  <!-- End Google Tag Manager (noscript) -->

  <!--[if lte IE 9]>
        <p class="p-4">You are using an <strong>outdated</strong> browser. Please <a href="https://browsehappy.com/">upgrade your browser</a> to improve your experience and security.</p>
    <![endif]-->

  <!-- Wrapper start -->
  <div class="wrapper">
    
    <!-- Overlay to maintain focus on nagitation -->

    <!-- VALIDATION ERRORS -->
    <?php if(count($errors) > 0): ?>
      <div class="alert alert-danger alert-dismissible mb-0" role="alert">
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>

        <strong><?php echo e(trans('theme.error'), false); ?>!</strong> <?php echo e(trans('messages.input_error'), false); ?><br><br>

        <ul class="list-group">
          <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li class="list-group-item list-group-item-danger"><?php echo e($error, false); ?></li>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
      </div>
    <?php endif; ?>

    <!-- Top promo bar -->
    <?php echo $__env->make('front_top_promo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Announcement -->
    <?php if(is_incevio_package_loaded('announcement')): ?>
      <?php echo $__env->make('announcement::announcement', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>

    <!-- Header start -->
    <header class="header">
      <!-- Primary Menu -->
      <?php echo $__env->make('theme::nav.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

      <!-- Mobile Menu -->
      <?php echo $__env->make('theme::nav.mobile', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
      <div class="close-sidebar">
        <strong><i class="fal fa-times"></i></strong>
      </div>
    </header>

    <div id="content-wrapper">
      <?php echo $__env->yieldContent('content'); ?>
    </div>

    <div id="loading">
      <img id="loading-image" src="<?php echo e(theme_asset_url('img/loading.gif'), false); ?>" alt="busy...">
    </div>

    <!-- Quick View Modal-->
    <div id="quickViewModal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="false"></div>

    <!-- my Dynamic Modal-->
    <div id="myDynamicModal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="false"></div>

    
    
    
    

    <!-- footer start -->
    <?php echo $__env->make('theme::nav.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  </div>
  <!-- Wrapper end -->

  <!-- MODALS -->
  <?php if (! (Auth::guard('customer')->check())): ?>
    <?php echo $__env->make('theme::auth.modals', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <?php endif; ?>

  <script src="<?php echo e(theme_asset_url('js/app.js'), false); ?>"></script>
  

  
  <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/css/toastr.min.css" rel="stylesheet">
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>

  <?php echo $__env->make('scripts.demo_restrict', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <?php echo $__env->make('theme::notifications', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <!-- AppJS -->
  <?php echo $__env->make('theme::scripts.appjs', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  
  <?php if(is_incevio_package_loaded('announcement')): ?>
    <?php echo $__env->make('announcement::script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <?php endif; ?>

  <!-- otp-login scripts -->
  <?php if(is_incevio_package_loaded('otp-login')): ?>
    <?php echo $__env->make('otp-login::scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <?php endif; ?>

  
  <?php if(is_incevio_package_loaded('searchAutocomplete')): ?>
    <?php echo $__env->make('searchAutocomplete::scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <?php endif; ?>

  
  <?php if(is_incevio_package_loaded('comparison')): ?>
    <?php echo $__env->make('comparison::script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <?php endif; ?>

  <!-- Page Scripts -->
  <?php echo $__env->yieldContent('scripts'); ?>

  
  <?php if(config('app.demo') == true && \Str::contains(url()->current(), 'zcart')): ?>
    <?php echo $__env->make('partials.demo_purchase_btn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <?php endif; ?>
  <?php echo $__env->make('partials._theme_change_btns', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <script>
    // Dynamic theme colors
    const setTheme = theme => document.documentElement.setAttribute('theme', theme);
    document.getElementById('zcart-js-theme-select').addEventListener('change', function() {
      setTheme(this.value);
    });

    document.addEventListener("DOMContentLoaded", function() {
      var lazyImages = [].slice.call(document.querySelectorAll(".lazy"));

      if ("IntersectionObserver" in window) {
        let lazyImageObserver = new IntersectionObserver(function(entries, observer) {
          entries.forEach(function(entry) {
            if (entry.isIntersecting) {
              let lazyImage = entry.target;
              lazyImage.src = lazyImage.dataset.src;
              lazyImage.classList.remove("lazy");
              lazyImageObserver.unobserve(lazyImage);
            }
          });
        });

        lazyImages.forEach(function(lazyImage) {
          lazyImageObserver.observe(lazyImage);
        });
      } else {
        // Possibly fall back to a more compatible method here
      }
    });
  </script>
</body>

</html>
<?php /**PATH /home/ddondola/public_html/public/themes/default/views/layouts/main.blade.php ENDPATH**/ ?>