<div class="main-menu mobile-mega-menu">
  <nav class="bg-white">
    <?php if(is_null($hidden_menu_items) || !in_array('Categories', $hidden_menu_items)): ?>
      <ul class="main-menu-nav bg-white">
        <?php $__currentLoopData = $all_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $catGroup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <?php
            $categories_count = $catGroup->subGroups->sum('categories_count');
          ?>

          <li class="flex-center-y">
            <a href="<?php echo e(route('categoryGrp.browse', $catGroup->slug), false); ?>"><?php echo e($catGroup->name, false); ?></a>
            <ul>
              <?php $__currentLoopData = $catGroup->subGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subGroup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li>
                  <a href="<?php echo e(route('categories.browse', $subGroup->slug), false); ?>"><?php echo e($subGroup->name, false); ?></a>
                  
                  <ul class="child-categories">
                    
                    <?php $__currentLoopData = $subGroup->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <li>
                        <a href="<?php echo e(route('category.browse', $cat->slug), false); ?>"><?php echo e($cat->name, false); ?></a>
                      </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    
                  </ul>
                </li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
          </li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </ul>
    <?php endif; ?>
  </nav>
</div>

<div class="main-menu-top">
  <div class="main-menu-top-inner">
    <div class="main-menu-top-box flex-wrap flex-center">
      <?php if(auth()->guard('customer')->check()): ?>
        <div class="main-menu-top-item mm-acount">
          <a href="<?php echo e(route('account', 'dashboard'), false); ?>" class="flex-center-y">
            <i class="fa fa-user"></i>
            <p><?php echo e(Str::upper(trans('theme.account')), false); ?></p>
          </a>
        </div>
        <div class="main-menu-top-item mm-log">
          <a href="<?php echo e(route('customer.logout'), false); ?>" class="flex-center-y">
            <i class="fa fa-sign-out"></i>
            <p><?php echo e(Str::upper(trans('theme.logout')), false); ?></p>
          </a>
        </div>
      <?php else: ?>
        <div class="main-menu-top-item mm-log">
          <a href="<?php echo e(route('account', 'dashboard'), false); ?>" class="flex-center-y">
            <i class="fa fa-sign-in"></i>
            <p><?php echo e(Str::upper(trans('theme.login')), false); ?></p>
          </a>
        </div>
        <?php endif; ?>
        <div class="main-menu-top-item mm-lang">
          <div class="form-group">
            <select name="lang" id="mobile-lang">
              <?php $__currentLoopData = config('active_locales'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option dd-link="<?php echo e(route('locale.change', $lang->code), false); ?>" value="<?php echo e($lang->code, false); ?>" data-imagesrc="<?php echo e(get_flag_img_by_code(array_slice(explode('_', $lang->php_locale_code), -1)[0], true), false); ?>" <?php echo e($lang->code == \App::getLocale() ? 'selected' : '', false); ?>>
                  <?php echo e($lang->code, false); ?>

                </option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
          </div>
        </div>

        <?php if(is_incevio_package_loaded('dynamic-currency')): ?>
          <li class="currency">
            <select name="currency" id="currencyChange">
              <?php $__currentLoopData = get_active_currencies(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                  if (get_dynamic_currency_attr('iso_code') == $item->iso_code) {
                      $selected = 'selected';
                  } elseif (!session()->has('currency') && $item->iso_code == get_system_currency()) {
                      $selected = 'selected';
                  } else {
                      $selected = '';
                  }
                ?>
                <option value="<?php echo e($item->iso_code, false); ?>" <?php echo e($selected ?? '', false); ?>>
                  <?php echo e($item->iso_code ?? '', false); ?> (<?php echo e($item->symbol ?? '', false); ?>)
                </option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
          </li>
        <?php endif; ?>
      </div>
    </div>
  </div>
  <div class="main-menu-bottom">
    <div class="main-menu-bottom-inner">
      <div class="main-menu-bottom-box">
        <div class="main-menu-bottom-item">
          <a href="<?php echo e(route('account', 'wishlist'), false); ?>">
            <i class="fal fa-heart small"></i> <span><?php echo e(trans('theme.wishlist'), false); ?></span>
          </a>
        </div>

        <?php if(is_null($hidden_menu_items) || !in_array('Brands', $hidden_menu_items)): ?>
          <div class="main-menu-bottom-item">
            <a href="<?php echo e(route('brands'), false); ?>">
              <i class="fal fa-crown small"></i> <span><?php echo e(trans('theme.brands'), false); ?></span>
            </a>
          </div>
        <?php endif; ?>

        <?php if(is_null($hidden_menu_items) || !in_array('Vendors', $hidden_menu_items)): ?>
          <div class="main-menu-bottom-item">
            <a href="<?php echo e(route('shops'), false); ?>">
              <i class="fal fa-store small"></i> <span><?php echo e(trans('theme.vendors'), false); ?></span>
            </a>
          </div>
        <?php endif; ?>

        <?php if(is_null($hidden_menu_items) || !in_array('Sale', $hidden_menu_items)): ?>
          <div class="main-menu-bottom-item">
            <a href="<?php echo e(url('/selling'), false); ?>">
              <i class="fal fa-seedling small"></i> <span><?php echo e(trans('theme.sell'), false); ?></span>
            </a>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div>
<?php /**PATH /home/ddondola/public_html/public/themes/default/views/nav/mobile.blade.php ENDPATH**/ ?>