<?php
  $SEOurl = url()->current();
  $SEOtitle = $title ?? get_platform_title();
  $SEOdescription = config('seo.meta.description');
  $SEOimage = filter_var(config('seo.meta.image'), FILTER_VALIDATE_URL) ? config('seo.meta.image') : get_logo_url('system', 'logo');
  $SEOkeywords = config('seo.meta.keywords');
  $character_limit = config('seo.meta.description_character_limit');

  // For Products
  if (isset($item)) {
      $SEOtitle = $item->meta_title ?? $item->title;
      $SEOdescription = $item->meta_description ?? substr(strip_tags($item->description), 0, $character_limit);
      $SEOimage = get_product_img_src($item, 'full');
      $SEOkeywords = implode(', ', $item->tags->pluck('name')->toArray());
  }

  // For Categories
  elseif (Request::is('categories/*') || Request::is('categorygrp/*') || Request::is('category/*')) {
      $category = $category ?? ($categorySubGroup ?? $categoryGroup);
      $SEOtitle = $category->meta_title ?? $SEOtitle;
      $SEOdescription = $category->meta_description ?? $SEOdescription;
  }

  // For Shops
  elseif (Request::is('shop/*')) {
      $SEOtitle = $shop->getName() ?? $SEOtitle;
      $SEOdescription = $shop->description ? substr(strip_tags($shop->description), 0, $character_limit) : $SEOdescription;
  }

  // For Brands
  elseif (Request::is('brand/*')) {
      $SEOtitle = $brand->getName() ?? $SEOtitle;
      $SEOdescription = $brand->description ? substr(strip_tags($brand->description), 0, $character_limit) : $SEOdescription;
  }

  // For blogs
  elseif (isset($blog)) {
      $SEOtitle = $blog->title;
      $SEOdescription = substr(strip_tags($blog->excerpt), 0, $character_limit);
      $SEOimage = get_storage_file_url(optional($blog->image)->path, 'blog');
      $SEOkeywords = implode(', ', $blog->tags->pluck('name')->toArray());
  }

  // For events
  elseif (isset($event)) {
      $SEOtitle = $event->title;
      $SEOdescription = substr(strip_tags($event->excerpt), 0, $character_limit);
      $SEOimage = get_storage_file_url(optional($event->image)->path, 'blog');
  }

  // For pages
  elseif (isset($page)) {
      $SEOtitle = $page->title;
      $SEOdescription = substr(strip_tags($page->content), 0, $character_limit);
      $SEOimage = get_storage_file_url(optional($page->image)->path, 'page');
      // $SEOkeywords = implode(', ', $page->tags->pluck('name')->toArray());
  }

  $SEOtitle = strip_tags($SEOtitle);
  $SEOdescription = strip_tags($SEOdescription);
?>

<meta charset="utf-8">

<?php if(is_incevio_package_loaded('googleAnalytics')): ?>
  <?php echo $__env->make('analytics::scripts.google_tag_manager', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>
<!-- End Google Tag Manager -->

<?php echo $__env->make('scripts.facebook_pixel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- End Meta Pixel Code -->

<?php echo $__env->make('scripts.twitter_pixel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- End Twitter Pixel Base Code -->

<?php echo $__env->make('scripts.tiktok_pixel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- End TikTok Pixel Base Code -->

<?php echo $__env->make('scripts.pinterest_pixel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- End Pinterest Pixel Base Code -->

<?php echo $__env->make('scripts.linkedin_pixel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- End LinkedIn Insight Tag Code -->

<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta content="text/html;charset=utf-8" http-equiv="Content-Type">
<meta name="csrf-token" content="<?php echo e(csrf_token(), false); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, shrink-to-fit=no">
<meta name="author" content="Incevio | incevio.com">
<meta name="format-detection" content="telephone=no">

<?php if(config('seo.enabled')): ?>
  <!-- Standard SEO -->
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  <meta name="referrer" content="<?php echo e($referrer ?? config('seo.meta.referrer'), false); ?>">
  <meta name="robots" content="<?php echo e($robots ?? config('seo.meta.robots'), false); ?>">
  <meta name="revisit-after" content="<?php echo e(config('seo.meta.revisit_after', '7 days'), false); ?>" />
  <meta name="description" content="<?php echo e($SEOdescription, false); ?>">
  <meta name="image" content="<?php echo e($SEOimage, false); ?>">
  <meta name="keywords" content="<?php echo e($SEOkeywords, false); ?>">

  <!-- Geo loacation -->
  <?php if(config('seo.meta.geo_region') !== ''): ?>
    <meta name="geo.region" content="<?php echo e(config('seo.meta.geo_region'), false); ?>">
    <meta name="geo.placename" content="<?php echo e(config('seo.meta.geo_region'), false); ?>">
  <?php endif; ?>

  <?php if(config('seo.meta.geo_position') !== ''): ?>
    <meta name="geo.position" content="<?php echo e(config('seo.meta.geo_position'), false); ?>">
    <meta name="ICBM" content="<?php echo e(config('seo.meta.geo_position'), false); ?>">
  <?php endif; ?>

  <!-- Dublin Core basic info -->
  <meta name="dcterms.Format" content="text/html">
  <meta name="dcterms.Type" content="text/html">
  <meta name="dcterms.Language" content="<?php echo e(config('app.locale'), false); ?>">
  <meta name="dcterms.Identifier" content="<?php echo e($SEOurl, false); ?>">
  <meta name="dcterms.Relation" content="<?php echo e(get_platform_title(), false); ?>">
  <meta name="dcterms.Publisher" content="<?php echo e(get_platform_title(), false); ?>">
  <meta name="dcterms.Coverage" content="<?php echo e($SEOurl, false); ?>">
  <meta name="dcterms.Contributor" content="<?php echo e($author ?? get_platform_title(), false); ?>">
  <meta name="dcterms.Title" content="<?php echo e($SEOtitle, false); ?>">
  <meta name="dcterms.Subject" content="<?php echo e($SEOkeywords, false); ?>">
  <meta name="dcterms.Description" content="<?php echo e($SEOdescription, false); ?>">

  <!-- Facebook OpenGraph -->
  <meta property="og:locale" content="<?php echo e(config('app.locale'), false); ?>">
  <meta property="og:url" content="<?php echo e($SEOurl, false); ?>">
  <meta property="og:site_name" content="<?php echo e(get_platform_title(), false); ?>">
  <meta property="og:title" content="<?php echo e($SEOtitle, false); ?>">
  <meta property="og:description" content="<?php echo e($SEOdescription, false); ?>">

  <?php if(isset($item)): ?>
    <meta property="og:type" content="product">
    <meta name="product:availability" content="<?php echo e($item->stock_quantity > 0 ? trans('theme.in_stock') : trans('theme.out_of_stock'), false); ?>">
    <meta name="product:price:currency" content="<?php echo e(get_system_currency(), false); ?>">
    <meta name="product:price:amount" content="<?php echo e(get_formated_currency($item->current_sale_price(), config('system_settings.decimals', 2)), false); ?>">
    <meta name="product:brand" content="<?php echo e($item->product->manufacturer->name, false); ?>">

    <?php
      $item_images = $item->images->count() ? $item->images : $item->product->images;

      if (isset($variants)) {
          // Remove images of current items from the variants imgs
          $other_images = $variants
              ->pluck('images')
              ->flatten(1)
              ->filter(function ($value, $key) use ($item) {
                  return $value->imageable_id != $item->id;
              });
          $item_images = $item_images->concat($other_images);
      }
    ?>

    <?php $__currentLoopData = $item_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <?php if(!$img->path) continue; ?>

      <meta property="og:image" content="<?php echo e(get_storage_file_url($img->path, 'full'), false); ?>">
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  <?php else: ?>
    <meta property="og:type" content="<?php echo e('website', false); ?>">
    <meta property="og:image" content="<?php echo e($SEOimage, false); ?>">
  <?php endif; ?>

  <meta property="og:image:width" content="1200" />
  <meta property="og:image:height" content="630" />

  <?php if(config('seo.meta.video') !== ''): ?>
    <meta name="og:video" content="<?php echo e($video ?? config('seo.meta.video'), false); ?>">
  <?php endif; ?>

  <?php if(config('seo.meta.fb_app_id') !== ''): ?>
    <meta property="fb:app_id" content="<?php echo e(config('seo.meta.fb_app_id'), false); ?>" />
  <?php endif; ?>

  <!-- Twitter Card -->
  <meta name="twitter:title" content="<?php echo e($SEOtitle, false); ?>">
  <meta name="twitter:description" content="<?php echo e($SEOdescription, false); ?>">
  <meta name="twitter:image" content="<?php echo e($SEOimage, false); ?>">
  <meta name="twitter:image:alt" content="<?php echo e($SEOtitle, false); ?>">

  <?php if(isset($item)): ?>
    <meta name="twitter:card" content="product">
    <meta name="twitter:label1" content="price">
    <meta name="twitter:data1" content="<?php echo e($item->current_sale_price(), false); ?>">
    <meta name="twitter:label2" content="availability">
    <meta name="twitter:data2" content="<?php echo e($item->stock_quantity > 0 ? trans('theme.in_stock') : trans('theme.out_of_stock'), false); ?>">
    <meta name="twitter:label3" content="currency">
    <meta name="twitter:data3" content="<?php echo e(get_system_currency(), false); ?>">
    <meta name="twitter:label4" content="brand">
    <meta name="twitter:data4" content="<?php echo e($item->product->manufacturer->name, false); ?>">
    <meta name="twitter:label4" content="seller">
    <meta name="twitter:data4" content="<?php echo e($item->shop->name, false); ?>">
  <?php elseif(config('seo.meta.twitter_card') !== ''): ?>
    <meta name="twitter:card" content="<?php echo e(config('seo.meta.twitter_card'), false); ?>">
  <?php endif; ?>

  <?php if(config('seo.meta.twitter_site') !== ''): ?>
    <meta name="twitter:site" content="<?php echo e(config('seo.meta.twitter_site'), false); ?>">
  <?php endif; ?>

  <?php if(isset($item)): ?>
    <!-- Microdata Product Page-->
    <script type="application/ld+json">
      {
        "@context": "http://schema.org",
        "@type": "Product",
        "name": "<?php echo e($SEOtitle, false); ?>",
        "description": "<?php echo e($SEOdescription, false); ?>",
        "image": "<?php echo e($SEOimage, false); ?>",
        "brand": {
          "@type": "Brand",
          "name": "<?php echo e($item->product->manufacturer->name, false); ?>"
        },
        "sku": "<?php echo e($item->sku, false); ?>",
        <?php if($item->product->gtin_type && $item->product->gtin): ?>
          "<?php echo e($item->product->gtin_type, false); ?>": "<?php echo e($item->product->gtin, false); ?>",
        <?php endif; ?>
        "offers": {
          "@type": "Offer",
          "url": "<?php echo e($SEOurl, false); ?>",
          "availability": "http://schema.org/InStock",
          "priceCurrency": "<?php echo e(get_system_currency(), false); ?>",
          "price": "<?php echo e(number_format($item->current_sale_price(), 2, '.', ''), false); ?>"
        }
        <?php if($item->feedbacks_count > 0): ?>
          ,
          "aggregateRating": {
            "@type": "AggregateRating",
            "ratingValue": "<?php echo e(get_formated_decimal($item->feedbacks->avg('rating'), true, 1), false); ?>",
            "bestRating": "5",
            "worstRating": "1",
            "reviewCount": "<?php echo e($item->feedbacks_count, false); ?>"
          }
        <?php endif; ?>
      }
    </script>
  <?php endif; ?>
<?php endif; ?>

<title><?php echo e($SEOtitle, false); ?></title>
<link rel="icon" href="<?php echo e(get_icon_url('system', 'thumbnail'), false); ?>" type="image/x-icon" />

<link rel="apple-touch-icon" href="<?php echo e(get_icon_url('system', 'thumbnail'), false); ?>" />
<?php /**PATH /home/ddondola/public_html/resources/views/meta.blade.php ENDPATH**/ ?>